/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import net.minecraft.class_11659;
import net.minecraft.class_11785;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.base.BoneSnapshots;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRendererInternals;
import software.bernie.geckolib.renderer.base.RenderPassInfo;

public interface GeoRenderer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRendererInternals<T, O, R> {
    @Override
    default public int getRenderColor(T animatable, @Nullable O relatedObject, float partialTick) {
        return -1;
    }

    @Override
    default public int getPackedOverlay(T animatable, @Nullable O relatedObject, float u, float partialTick) {
        return class_4608.field_21444;
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public @Nullable class_1921 getRenderType(R renderState, class_2960 texture) {
        return class_12249.method_75994((class_2960)texture);
    }

    @Override
    @ApiStatus.OverrideOnly
    default public void addRenderData(T animatable, @Nullable O relatedObject, R renderState, float partialTick) {
    }

    @Override
    default public void setMolangQueryValues(T animatable, @Nullable O relatedObject, R renderState, float partialTick) {
    }

    default public void performRenderPass(R renderState, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraState) {
        this.performRenderPass(renderState, poseStack, renderTasks, cameraState, null);
    }

    default public void performRenderPass(R renderState, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraState, @Nullable RenderPassInfo.BoneUpdater<R> boneUpdater) {
        poseStack.method_22903();
        class_1921 renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        RenderPassInfo<R> renderPassInfo = RenderPassInfo.create(this, renderState, poseStack, cameraState, renderType != null);
        if (boneUpdater != null) {
            renderPassInfo.addBoneUpdater(boneUpdater);
        }
        if (this.firePreRenderEvent(renderPassInfo, renderTasks)) {
            this.preRenderPass(renderPassInfo, renderTasks);
            this.scaleModelForRender(renderPassInfo, 1.0f, 1.0f);
            this.adjustRenderPose(renderPassInfo);
            this.preApplyRenderLayers(renderPassInfo, renderTasks);
            renderPassInfo.captureModelRenderPose();
            this.submitRenderTasks(renderPassInfo, (class_11785)renderTasks, renderType);
            this.submitPerBoneRenderTasks(renderPassInfo, renderTasks);
            this.applyRenderLayers(renderPassInfo, renderTasks);
        }
        poseStack.method_22909();
        this.postRenderPass(renderPassInfo, renderTasks);
    }

    default public void preRenderPass(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
    }

    default public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        if (widthScale != 1.0f || heightScale != 1.0f) {
            renderPassInfo.poseStack().method_22905(widthScale, heightScale, widthScale);
        }
    }

    default public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
    }

    default public void adjustModelBonesForRender(RenderPassInfo<R> renderPassInfo, BoneSnapshots snapshots) {
    }

    default public void submitRenderTasks(RenderPassInfo<R> renderPassInfo, class_11785 renderTasks, @Nullable class_1921 renderType) {
        if (renderType == null) {
            return;
        }
        int packedLight = renderPassInfo.packedLight();
        int packedOverlay = renderPassInfo.packedOverlay();
        int renderColor = renderPassInfo.renderColor();
        renderTasks.method_73483(renderPassInfo.poseStack(), renderType, (pose, vertexConsumer) -> {
            class_4587 poseStack = renderPassInfo.poseStack();
            poseStack.method_22903();
            poseStack.method_23760().method_66521(pose);
            renderPassInfo.renderPosed(() -> renderPassInfo.model().render(renderPassInfo, vertexConsumer, packedLight, packedOverlay, renderColor));
            poseStack.method_22909();
        });
    }

    default public void postRenderPass(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
    }
}

